/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.util.ApplesoftToken;
import com.webcodepro.applecommander.util.ApplesoftTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class ApplesoftFileFilter
implements FileFilter {
    @Override
    public byte[] filter(FileEntry fileEntry) {
        ApplesoftToken token;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        ApplesoftTokenizer tokenizer = new ApplesoftTokenizer(fileEntry);
        boolean firstLine = true;
        while (tokenizer.hasMoreTokens() && (token = tokenizer.getNextToken()) != null) {
            if (token.isLineNumber()) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    printWriter.println();
                }
                printWriter.print(token.getLineNumber());
                printWriter.print(" ");
                continue;
            }
            if (token.isToken()) {
                printWriter.print(token.getTokenString());
                continue;
            }
            printWriter.print(token.getStringValue());
        }
        printWriter.close();
        return byteArray.toByteArray();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        String fileName = fileEntry.getFilename().trim();
        if (!fileName.toLowerCase().endsWith(".bas")) {
            fileName = fileName + ".bas";
        }
        return fileName;
    }
}

